from utils.tools import load_data, load_model
from utils.method_factory import detect_method
from detect_methods.mink import mink
from detect_methods.sharded_likelihood import sharded_likelihood
class detector:
    def __init__(self, args):
        self.model, self.tokenizer = load_model(args.model_path)
        self.data = load_data(args) 
        self.args = args
        
    def run_detect(self):
        detect_method(self.data, self.model, self.tokenizer, self.args)
        
    def detect_method(data, model, tokenizer, args):
        if args.method_name == "mink":
            print("Detecting using mink...")
            return mink(data, model, tokenizer, key_name=args.key_name, output_dir=args.output_dir)

        elif args.method_name == "sharded_likelihood":
            print("Detecting using sharded_likelihood...")
            return sharded_likelihood(
                data,
                args.model_name,
                tokenizer,
                log_file_path=args.log_file_path,
                context_len=args.sharded_likelihood_context_len,
                stride=args.sharded_likelihood_stride,
                num_shards=args.sharded_likelihood_num_shards,
                permutations_per_shard=args.sharded_likelihood_permutations_per_shard,
                output_dir=args.output_dir
            )
        else:
            raise ValueError("Method not implemented")
        # TODO: add more methods here